import { Link, useLocation } from 'react-router-dom'
import { GraduationCap } from 'lucide-react'
import { motion } from 'framer-motion'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app">
      <header className="header">
        <div className="container">
          <div className="header-content">
            <motion.div 
              className="logo"
              whileHover={{ scale: 1.05, rotate: -5 }}
              transition={{ type: "spring", stiffness: 400 }}
            >
              <GraduationCap className="logo-icon" size={32} color="#F97316" />
              <span className="logo-text">EduTutor</span>
            </motion.div>
            <nav className="nav">
              <Link 
                to="/" 
                className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои уроки
              </Link>
              <Link 
                to="/book" 
                className={`nav-link ${location.pathname === '/book' ? 'active' : ''}`}
              >
                Назначить урок
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main">
        {children}
      </main>

      <footer className="footer">
        <div className="container">
          <div className="footer-content">
            <div className="footer-section">
              <div className="footer-logo">
                <GraduationCap className="footer-logo-icon" size={28} color="#FDBA74" />
                <h2>EduTutor</h2>
              </div>
              <p className="footer-description">
                Профессиональное онлайн-репетиторство по школьным предметам с опытными преподавателями
              </p>
            </div>
            <div className="footer-section">
              <h3 className="footer-title">Контакты</h3>
              <ul className="footer-links">
                <li>
                  <span>Телефон:</span>
                  <a href="tel:+79991234567">+7 (999) 123-45-67</a>
                </li>
                <li>
                  <span>Email:</span>
                  <a href="mailto:info@edututor.ru">info@edututor.ru</a>
                </li>
                <li>
                  <span>Адрес:</span>
                  <span>г. Москва, ул. Образовательная, д. 1</span>
                </li>
              </ul>
            </div>
            <div className="footer-section">
              <h3 className="footer-title">Режим работы</h3>
              <ul className="footer-links">
                <li>Пн-Пт: 9:00 - 21:00</li>
                <li>Сб: 10:00 - 18:00</li>
                <li>Вс: Выходной</li>
              </ul>
            </div>
          </div>
          <div className="footer-bottom">
            <p>&copy; 2025 EduTutor. Все права защищены.</p>
          </div>
        </div>
      </footer>
    </div>
  )
}

export default Layout

